<?php
chdir("../../../../");

require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');


/***
 * Obtiene todos los campos de la tabla log_fieldallmodule
 */

global $adb;

function createBlock($label,$instanceModule, $sequence)
{
    global $adb;
    #$adb->setDebug(true);
    $blockValueMap = [
        'blocklabel' => $label,
        'display_status' => 1,
        'iscustom' => 0,
        'sequence' => $sequence
    ];

    $block = new Vtiger_Block();
    $block = $block->getInstance($label,$instanceModule);
    if(empty($block))
    {   
        $block = new Vtiger_Block();
        $block->initialize($blockValueMap,$instanceModule);
        try {
            $block->save($instanceModule);
        } catch (Exception $ex) {
            throw new Exception($ex->getMessage());
        }
    }
    
    return $block;
}

function createField($attr,$block)
{
    global $adb;
    #$adb->setDebug(true);
    #Verifica que el campo no exista
    $q = $adb->pquery("SELECT fieldid FROM vtiger_field WHERE columnname = ? AND tablename = ?",[$attr[0],$attr[1]]);
    #$adb->setDebug(false);
    if($adb->num_rows($q) == 0)
    {
        $fieldInstance = new Vtiger_Field();
        $fieldInstance->name = $attr[0];                          //Usually matches column name
        $fieldInstance->table = $attr[1];
        $fieldInstance->column = $attr[2];                           //Must be lower case
        $fieldInstance->label = $attr[3];                   //Upper case preceeded by LBL_
        $fieldInstance->columntype = $attr[6];        //
        $fieldInstance->uitype = $attr[4];                             //Multi-Combo picklist
        $fieldInstance->displaytype = 1;
        $fieldInstance->typeofdata = $attr[7];   //V=Varchar?, M=Mandatory, O=Optional

        if($fieldInstance->uitype == 16 || $fieldInstance->uitype == 33 || $fieldInstance->uitype == 15)
        {
            $fieldInstance->setPicklistValues($attr[5]);
        }

        $block->addField($fieldInstance);
    }


}

function main()
{
    global $adb;
    $fieldname = $_POST['fieldname'];
    #$adb->setDebug(true);
    $r = $adb->pquery("SELECT * FROM log_fieldallmodule WHERE columna_database = ? and migrated = 0 LIMIT 1",[$fieldname]);
    #debug($adb->num_rows($r),1);
    if($adb->num_rows($r) > 0)
    {
        $row = $adb->query_result_rowdata($r,0);
        $tabid = $row["module"];
        $r2 = $adb->pquery("SELECT * FROM vtiger_tab WHERE tabid = ? LIMIT 1",[$tabid]);
        
        if($adb->num_rows($r2) > 0)
        {
            $tabrow = $adb->query_result_rowdata($r2,0); 
            $moduleName = $tabrow["name"];
            $moduleInstance =  Vtiger_Module::getInstance($moduleName);
            $blockInstance = createBlock($row["bloque_name"],$moduleInstance,$row["bloque_sequence"]);
            if(!empty($row["picklist"]))
            {
                $s_ = decode_html($row["picklist"]);
                $r_ = json_decode($s_,true);
                $k_ = array_keys($r_);
                unset($k_[0]);

            }
            createField([
                $row["columna_database"], #columnname
                $row["tabla"], #tablename
                $row["columna_database"],  #fieldname
                $row["label_view"], #labelname
                $row["uitype"], #uitype
                $k_,  #valores,
                $row["column_type"],
                $row["typeofdata"]
                ],$blockInstance);
            $adb->pquery("UPDATE log_fieldallmodule SET migrated = 1 WHERE columna_database = ?",[$fieldname]);
        
        }
        #debug($row);
        
    }

    $response = [];


    echo json_encode($response);
}

main();




?>